/*************************************************************************/
/*  MANYFAX.C     Send many faxes automatically by calling QFAX.EXE      */
/*          Copyright (C) 1997 Anthony Mai. All rights reserved          */
/*                                                                       */
/*  This C program serves two purposes:                                  */
/*      1.To serve as an example how you can use spawnv() function to    */
/*        call QFAX and send fax from your own C/C++ application         */
/*      2.To serve as a useful program for fax broadcasting              */
/*                                                                       */
/*  You may modify and use this program for any purpose as long as this  */
/*  copyright notice remains intact. But you may not re-distribute this  */
/*  file except when you distribute it in it's original form, as part of */
/*  the QFAXV108.ZIP shareware package. If you made any significant      */
/*  modification to make it better, The original author would appreciate */
/*  you send a copy to E-Mail QFAX@QFAX.COM if possible.                 */
/*************************************************************************/

/*************************************************************************/
/*  Usage of MANYFAX.EXE is like this:                                   */
/*                                                                       */
/*      MANYFAX [-f] [-db list_file]  [-log log_file]  file1 [file2] ... */
/*                                                                       */
/*  Items in [] means it is optional. The optional -f flag means it'll   */
/*  fax *.FAX files directly, otherwise it assumes the files are text    */
/*  files. The default list file is manyfax.lst. The default log file    */
/*  is MANYFAX.LOG                                                       */
/*************************************************************************/

#include <stdio.h>
#include <conio.h>
#include <process.h>
#include <string.h>
#include <time.h>

#define  TXT    0               /* Fax text files ************************/
#define  FAX    1               /* Fax FAX files  ************************/

int filetype;                   /* Type fo files to be faxed: TXT or FAX */
int successful, failure, total; /* Counting number of faxes sent/not sent*/
int i,j,k,Ans, returncode;      /* A few public variables ****************/
char qfaxcmd[128];              /* The QFAX.EXE command with it's path ***/
char args[32][64];              /* Array of argument strings. Each string*/
                                /* less than 64 chars. Max 32 arguments **/
char *arglist[33];              /* Array of pointers to arguments. Last **/
                                /* pointer must be NULL to terminate *****/
char strname[16][16];           /* Name of used defined strings. Up to 16*/
                                /* names each shorter than 32 chars ******/
char strings[16][64];           /* Up to 16 user defined strings, each is*/
                                /* Shorter than 64 chars *****************/
char tmpstr[256];               /* A temprary string for file reading ****/
char str1[64], str2[64];        /* Two temprary strings ******************/
char faxnumber[48];             /* string containing the fax number ******/

char listName[64] = "manyfax.lst";   /* Name of default fax list file ****/
char logName[64]  = "manyfax.log";   /* Name of default fax log file *****/

FILE * fFaxList, * fFaxLog, * fcfg; /* Fax list file, log file, cfg file */

void usage()
{
 printf("Usage of this program is:\n\n"
        "  manyfax  [-db list_file] [-log log_file] [-f] file1 [file2] ...\n\n"
        "Example:\n"
        "  manyfax  -db myfax.lst  -log faxsend.log  cover.txt mylett.txt\n"
        "This example sends file COVER.TXT and MYLETT.TXT to faxes listed\n"
        "in file MYFAX.LST and write the fax result to file FAXSEND.LOG\n"
        "Use '-f' option flag if you are faxing *.FAX files instead.\n"
        "Please read USAGE.TXT for detailed usages.\n"
        "E-Mail QFAX@QFAX.COM if there's a problem.\n");
}

int readline()
/* Process the info read from the fax list file. and decide what to do ***/
/* returns: 0 -> The line is ignored. 1 -> It has just defined a string **/
/* return 2 -> It has just read a fax number so it will fax out **********/
{
 int ii, jj, kk;
 char onechar;

  str1[0] = '\0'; str2[0] = '\0';
  sscanf(tmpstr, "%s", str1);           /* Read in the first word ********/

  /* This first word must end with a ':' to be useful. Or be discarded ***/
  ii = jj = strlen(str1);
  if (ii < 2) return(0);                /* It's a blank line, discard ****/

  if (str1[ii-1] != ':') return(0);     /* End of first word is not ':'***/

  ii--; str1[ii] = '\0';                /* Get rid of the ':' ************/
  while (ii-- > 0) str1[ii] = toupper(str1[ii]); /* All upper case chars */

  if (strcmp(str1, "FAX")) { /* Is this first word "FAX"? none 0 -> No   */
     /* The word is not "FAX" so it must be a string definition **********/
     for (ii=0; ii<16; ii++) {          /* Overide same name string ******/
        if (strcmp(str1, strname[ii])) {/* Not a matching name */}
        else {                          /* Re-Define the matching string */
          for (/*Nothing*/; jj < strlen(tmpstr); jj++) {
             onechar = tmpstr[jj];      /* Skip the spaces and tabs ******/
             if (onechar != ' ' && onechar != 0x09) break;
            }
          kk = 0; strings[ii][kk] = '\0';
          for (/*Nothing*/; jj < strlen(tmpstr); jj++) {
             onechar = tmpstr[jj];
             if (onechar == ' ') onechar = '_'; /* Replace the space key */
             if (onechar == 0x0d || onechar == 0x0a) break;
             strings[ii][kk++] = onechar;
            }
          strings[ii][kk] = '\0';       /* Put a NULL to end of string ***/
          return(1);
         }
       }

     for (ii=0; ii<15; ii++) {  /* No string of matching string name *****/
        /* So find an empty string to define *****************************/
        if (strname[ii][0] == '\0') break;
       }
     strcpy(strname[ii], str1);         /* Name of the string ************/

     for (/*Nothing*/; jj < strlen(tmpstr); jj++) {
        onechar = tmpstr[jj];      /* Skip the spaces and tabs ******/
        if (onechar != ' ' && onechar != 0x09) break;
       }
     kk = 0; strings[ii][kk] = '\0';
     for (/*Nothing*/; jj < strlen(tmpstr); jj++) {
        onechar = tmpstr[jj];
        if (onechar == ' ') onechar = '_'; /* Replace the space key */
        if (onechar == 0x0d || onechar == 0x0a) break;
        strings[ii][kk++] = onechar;
       }
     strings[ii][kk] = '\0';       /* Put a NULL to end of string ***/
     return(1);
    }
  else { /* Yes the word is "FAX", then get the fax number and return 2  */
     ii = 0; faxnumber[ii] = '\0';
     for (/*Nothing*/; jj<strlen(tmpstr); jj++) {
       onechar = tmpstr[jj];
       if (onechar > ' ' && onechar < ':') {
           /* legitimate char for the fax number is between 0x21 and 0x39*/
           faxnumber[ii++] = onechar;
         }
       if (ii>46) break;        /* The fax number is getting too long ****/
      }
     faxnumber[ii] = '\0';      /* Put a NULL at the end *****************/
     return(2);                 /* Return value 2. Will fax immediately  */
    }
}


void cleanstr()
/* Clean up all string definitions */
{
  int ii;
  for (ii=0; ii<16; ii++) {
    strname[ii][0] = '\0'; strings[ii][0] = '\0';
   }
}

main(argc, argv)
  int argc;
  char * argv[];
{
 int fstnum, lstnum;    /* This identifies the first and last arguments */
                        /* that are identified as name of files to fax  */

  _asm {
    mov  ax, 03h
    int  10h
   } /*** This simply cleans the text mode screen *************************/

  if (argc == 1) {
     usage(); exit(-1);
    } /* If user typed "MANYFAX" only. Show a USAGE screen and exit. ******/

 /* Now construct the QFAX.EXE command, including the complete path ******/
 /* First we assume QFAX.EXE and MANYFAX.EXE are under the same directory*/
 /* argv[0] contains the complete path name of MANYFAX.EXE ***************/

 strcpy(qfaxcmd, argv[0]);
 i = strlen(qfaxcmd) - 1;
 while (i>0 && qfaxcmd[i] != '\\') i--;
 qfaxcmd[i+1] = '\0';

 /* Now we have the complete path of MANYFAX.EXE, including the back slash*/
 /* Just append "QFAX.EXE" to it and we have the QFAX command *************/

 strcat(qfaxcmd, "QFAX.EXE");

 /* Test whether the the QFAX path and file name is correct or not */
 if ((fFaxList = fopen(qfaxcmd, "rb")) == NULL) {
      printf("%s can not be found!\n", qfaxcmd); exit(-1);
     }
 else fclose(fFaxList);

 /* Now process the command line arguments *******************************/
 /* First assuming we will fax TEXT files instead of FAX files ***********/
 filetype = TXT;
 fstnum = argc;
 lstnum = 0;
 i = 1;
 while (i<argc) {
    if (argv[i][0] == '-') switch (argv[i][1]) {
      case 'd':
      case 'D': i++; strcpy(listName, argv[i]); i++; break;
      case 'l':
      case 'L': i++; strcpy(logName,  argv[i]); i++; break;
      case 'f':
      case 'F': filetype = FAX; i++; break;
     }
    else { /* If it is not started by '-' it must be the file name *******/
      fstnum = i; lstnum = argc - 1; break; /* Break out and continue ****/
     }
   }

 if (fstnum > lstnum) {
    printf("You have not specified any file to be faxed on command line\n");
    usage(); exit(-1);
   }

  if ((fFaxList = fopen(listName, "rb")) == NULL) {
     printf("Fax list file %s not found\n", listName); exit(-1);
    }

  /* OK every thing is fine and the fax list and fax log file is opened */
  /* We will read from the fax list and then call QFAX to fax out *******/

  printf("    Manyfax.exe is going to send faxes to all fax numbers listed\n"
         "in the file  %s.  Results will be logged in  %s\n"
         "The following files will be faxed:\n ", listName, logName);
  for (i=fstnum; i<=lstnum; i++) printf(" %s", argv[i]);
  printf("\n\nIt is ILLEGAL in USA and many other countries to send UNSOLICITED fax!\n");
  printf("Are you sure you want to continue? Press 'c' to continue. 'q' to quit.\n");
  while((Ans = getch()) != 'c' && Ans != 'q') {}
  if (Ans != 'c') {
     printf("Fax broadcasting aborted\n");
     exit(-1);
    }

  cleanstr(); /* Clean out all string definitions ***********************/
  total = successful = failure;
  while (!feof(fFaxList)) {
    /* read a whole line into tmpstr ************************************/
    tmpstr[0] = '\0'; /* Clean out the tmpstr first *********************/
    fgets(tmpstr, 256, fFaxList);
    j = readline();
    switch(j) {
       case 1:  break;                  /* A string has been defined ****/
       case 2:  /* A fax number is read in. Will fax now ****************/
                /* So construct the argument list and fax out ***********/

                j = 0; /* Start with the first argument to be "QFAX" ****/
                strcpy(args[j], "QFAX"); arglist[j] = args[j]; j++;
                strcpy(args[j], "-nod"); arglist[j] = args[j]; j++;
                if (filetype == FAX) {
                   strcpy(args[j], "-f"); arglist[j] = args[j]; j++;
                  }

                if (fcfg = fopen("temp.cfg", "wb")) {
                  /*** Write string definitions to temp.cfg ***************/
                  for (i=0; i< 16; i++) { /* Add string definitions *******/
                    if (strname[i][0] != '\0'  && strings[i][0] != '\0') {
                      fprintf(fcfg, "Define %s %s\r\n",
                        strname[i], strings[i]);
                     }
                   }
                  fclose(fcfg);
                  strcpy(args[j], "-cfg"); arglist[j] = args[j]; j++;
                  strcpy(args[j], "temp.cfg"); arglist[j] = args[j]; j++;
                 }
                else {
                  /* Define strings on command line ***********************/
                  for (i=0; i< 16; i++) { /* Add string definitions *******/
                    if (strname[i][0] != '\0'  && strings[i][0] != '\0') {
                      strcpy(args[j], "-def"); arglist[j] = args[j]; j++;
                      strcpy(args[j], strname[i]); arglist[j] = args[j]; j++;
                      strcpy(args[j], strings[i]); arglist[j] = args[j]; j++;
                     }
                   }
                 }

                i = fstnum; /* The argument string for first file name **/
                while (i <= lstnum) {
                  strcpy(args[j], argv[i++]); arglist[j] = args[j]; j++;
                 }

                /*** Now the fax number *********************************/
                strcpy(args[j], faxnumber); arglist[j] = args[j]; j++;
                arglist[j] = NULL;
                /* Now all arguments of the QFAX command line are ready */
                _strtime(str2);      /* What's the starting time of fax */
                k = spawnv(_P_WAIT, qfaxcmd, arglist); total ++;
                if (k) failure ++; else successful ++;
                if ((fFaxLog = fopen(logName, "ab")) == NULL) {}
                else {
                  fprintf(fFaxLog, "%s Faxto: %s \t", str2, faxnumber);
                  fprintf(fFaxLog, "result: %d\r\n", k);
                  fclose(fFaxLog);
                 }
                cleanstr(); /* Clean up all string definition */
                break;
       default: /* The line is ignored */ break;
      }
   }
  fclose(fFaxList);
  printf("\nAll faxes are sent! Results are logged in %s\n", logName);
  printf("Total number of faxes sent: %d\n", total);
  printf("Number of successful faxes: %d\n", successful);
  printf("Number of faxes with error: %d\n", failure);
}

